///Jasmine 03/03/06
#define BASE_WINDOW			MultiPaneDlg
#include "DynaDlg.h"
#define m_ctrlPage			m_DynaCntrl

#define	 STR_PAGE_PREFIX	"Page"

#define	 ID_FIRST_PAGE		1

class ResizeGetNWiz : public DynaDlg	//MultiPaneDlg 
{
public :
	//ResizeGetNWiz(bool bIsMulti = false, bool bShowList = true) : MultiPaneDlg(IDD_GETN_WIZ, "Odlg8")//IDD_SET_COL_VAL_WIZ ///jasmine 02/21/06 name changed
	ResizeGetNWiz(bool bIsMulti = false, bool bShowList = true) : DynaDlg(IDD_GETN_WIZ, NULL, "Odlg8")
	{
		m_bMutiPane = bIsMulti;
		m_bShowList = bShowList;
	}	
	~ResizeGetNWiz()
	{
	}
	
	int  DoModalEx(HWND hParent)
	{
		InitMsgMap();
		int nRet = DynaDlg::DoModal(hParent);//MultiPaneDlg::DoModal(hParent);
		return nRet;
	}
	
	virtual int  Create(HWND hParent = NULL)
	{
		InitMsgMap();
		int nRet = DynaDlg::Create(hParent);//MultiPaneDlg::Create(hParent);
		Visible=true;		
		return nRet;
	}
	virtual string GetDlgName()
	{
		return "GetN Wiz";
	}
	
protected:	
EVENTS_BEGIN
	ON_INIT(OnInitDialog) 
	ON_SIZE(OnDlgResize)	
	ON_BN_CLICKED(IDOK, OnFinish)	
	ON_BN_CLICKED(IDCANCEL, OnCancel)	
	ON_BN_CLICKED(IDC_BTN_BACK, OnPrev)
	ON_BN_CLICKED(IDC_BTN_NEXT, OnNext)	
	ON_BN_CLICKED(IDC_BTN_UP_DOWN, OnShowBottomPanel)
	ON_USER_MSG(WM_USER_TREEEDITOR_VALUE_CHANGE, OnAfterValueChange)
EVENTS_END

//------------ Event Handlers ------------------------
	BOOL OnInitDialog()
	{
		vector<string>  vstrTipsUpDown = {"Show", "Hide"};
	    //MultiPaneDlg::OnInitDialog(IDC_PAGES, IDC_BTN_UP_DOWN, IDC_BOTTOM_PANEL, vstrTipsUpDown, GetDlgName());
		DynaDlg::OnInitDialog(IDC_PAGES, IDC_BTN_UP_DOWN, IDC_BOTTOM_PANEL, vstrTipsUpDown, GetDlgName());

		m_nCurrentID = ID_FIRST_PAGE;
		m_nPrevPageID = -1;
		m_nNextPageID = ID_FIRST_PAGE; //just let Next button editable
	    
		m_btnPrev = GetItem(IDC_BTN_BACK);	
		m_btnNext = GetItem(IDC_BTN_NEXT);	
		m_btnFinish = GetItem(IDOK);
		UpdateButtonStatus();
		
		BitmapRadioButton m_chkUpDown = GetItem(IDC_BTN_UP_DOWN);
		m_chkUpDown.Visible = m_bMutiPane;
		m_chkUpDown.Check = m_bMutiPane;
		
	 	InitPagePanel();
		InitListPanel();
	 	
		UpdateDlgSize();
		UpdateDlgShow();
	    SetInitReady();	
		return true;
	}
		
	bool OnDlgResize(int nType, int cx, int cy)
	{
		if(!IsInitReady())
			return TRUE;
		
		uint nButtonIDs[] = {IDOK, IDCANCEL, IDC_BTN_NEXT, IDC_BTN_BACK, 0};
		//MultiPaneDlg::OnDlgResize(nButtonIDs, cx, cy, false);
		DynaDlg::OnDlgResize(nButtonIDs, cx, cy, false);
		
		repositionControl(cx, cy);
		return TRUE;
	}
	
	virtual BOOL OnFinish(Control cntrl)///Jasmine 02/23/06 this should be virtual
	{		
		OnDestroy();
		return TRUE;
	}
	
	BOOL OnCancel(Control cntrl)
	{
		return FALSE;
	}
	
	BOOL OnPrev(Control ctrl)
	{
		int nID = GetPrevPageID();
		if(nID < 0)
			return false;
		
		UpdateIDs(nID);
		UpdateButtonStatus();
		
		OnBeforeUpdatePage();
		return UpdatePage();
	}
	
	BOOL OnNext(Control ctrl)
	{
		int nID = GetNextPageID();
		if(nID < 0)
			return false;
		
		UpdateIDs(nID);
		UpdateButtonStatus();
		
		OnBeforeUpdatePage();
		return UpdatePage();
	}
	
	bool	OnShowBottomPanel(Control ctrl)
	{
		MultiPaneDlg:: OnShowBottomPane(ctrl);
		return	true;
	}

	virtual void OnAfterValueChange(int nRow, DWORD lParam){;}
	
private:
	void repositionControl(int cx, int cy)
	{
		int nGap = GetControlGap();
		
		// reset list and page control
		Control ctrlPage = GetItem(IDC_PAGES);
		RECT 	rrPage;
		GetClientRect(ctrlPage, rrPage);		
		RECT 	rrList;
		GetClientRect(m_list, rrList);		
		if(m_bShowList)
		{
			rrList.left = nGap;
			rrList.bottom = rrPage.bottom;
			rrPage.left = rrList.left + RECT_WIDTH(rrList) + nGap;
		}
		MoveControl(ctrlPage, rrPage);
		MoveControl(m_list, rrList);		
	}
	
protected:
	virtual int		GetPrevPageID()  { return -1; }
	virtual int		GetNextPageID()  { return -1; }
	virtual bool	CheckGetPageTreeByID() {return false;}
	virtual bool    IsValidID(int nID) {return false;}	
	virtual void 	ContructTree() {}
	virtual void    OnBeforeUpdatePage() {}

	virtual bool	UpdatePage()
	{	
		TreeNode trPage = tree_get_node_by_id(m_trMain, m_nCurrentID);	
		m_ctrlPage.SetTree(trPage);		
		return true;
	}

	bool InitPagePanel()
	{
		ContructTree();
		TreeNode trPage = tree_get_node_by_id(m_trMain, m_nCurrentID);
		
		Control ctrl = GetItem(IDC_PAGES);
		m_ctrlPage.SetTree(trPage);
		m_ctrlPage.CreateControl(ctrl.GetSafeHwnd());
		return true;
	}
	
	bool InitListPanel()
	{
		m_list = GetItem(IDC_LIST);	
		int nCmdShow = m_bShowList? SW_NORMAL : SW_HIDE;
		m_list.ShowWindow(nCmdShow);
		return true;
	}
	
	void	UpdateIDs(int nID)
	{
		m_nCurrentID = nID;
		m_nPrevPageID = GetPrevPageID();
		m_nNextPageID = GetNextPageID();
	}
	
	void	UpdateButtonStatus()
	{
		EnablePrevButton( IsValidID(m_nPrevPageID) );		
		EnableNextButton( IsValidID(m_nNextPageID) );
	}
	
	
	BOOL	EnableFinishButton(BOOL bEnable)
	{
		m_btnFinish.Enable = bEnable;
		return true;
	}
	
	BOOL	EnableNextButton(BOOL bEnable)
	{
		m_btnNext.Enable = bEnable;
		return true;
	}
	
	BOOL	EnablePrevButton(BOOL bEnable)
	{
		m_btnPrev.Enable = bEnable;
		return true;
	}	
	
protected:
	Tree					m_trMain;
	TreeNode				m_trCurrent;
	
	int						m_nCurrentID;	
	int						m_nPrevPageID;
	int						m_nNextPageID;
	
	//DynaControl				m_ctrlPage;	///jasmine 03/03/06
	ListBox 				m_list;
	Button					m_btnPrev;
	Button					m_btnNext;
	Button					m_btnFinish;
	
	bool					m_bMutiPane;
	bool					m_bShowList;

};

